<?php
/**
 * Plugin Name:           AutomatorWP - Google Sheets
 * Plugin URI:            https://automatorwp.com/add-ons/google-sheets/
 * Description:           Connect AutomatorWP with Google Sheets.
 * Version:               1.0.9
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-google-sheets
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.8
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Google_Sheets
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Google_Sheets {

    /**
     * @var         AutomatorWP_Google_Sheets $instance The one true AutomatorWP_Google_Sheets
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Google_Sheets self::$instance The one true AutomatorWP_Google_Sheets
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Google_Sheets();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_GOOGLE_SHEETS_VER', '1.0.9' );

        // Plugin file
        define( 'AUTOMATORWP_GOOGLE_SHEETS_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_GOOGLE_SHEETS_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_GOOGLE_SHEETS_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_GOOGLE_SHEETS_DIR . 'includes/admin.php';
            require_once AUTOMATORWP_GOOGLE_SHEETS_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_GOOGLE_SHEETS_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_GOOGLE_SHEETS_DIR . 'includes/scripts.php';

            // Integrations
            require_once AUTOMATORWP_GOOGLE_SHEETS_DIR . 'includes/integrations/csv.php';

            // Actions
            require_once AUTOMATORWP_GOOGLE_SHEETS_DIR . 'includes/actions/add-row.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'google_sheets', array(
            'label' => 'Google Sheets',
            'icon'  => AUTOMATORWP_GOOGLE_SHEETS_URL . 'assets/google-sheets.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Google_Sheets instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Google_Sheets The one true AutomatorWP_Google_Sheets
 */
function AutomatorWP_Google_Sheets() {
    return AutomatorWP_Google_Sheets::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Google_Sheets' );
